/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cubemap;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.graphics.glutils.GLOnlyTextureData;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class FrameBufferCubemap
extends GLFrameBuffer<Cubemap> {
    private int currentSide;

    public FrameBufferCubemap(Pixmap.Format format2, int width, int height, boolean hasDepth) {
        this(format2, width, height, hasDepth, false);
    }

    public FrameBufferCubemap(Pixmap.Format format2, int width, int height, boolean hasDepth, boolean hasStencil) {
        super(format2, width, height, hasDepth, hasStencil);
    }

    @Override
    protected Cubemap createColorTexture() {
        int glFormat = Pixmap.Format.toGlFormat(this.format);
        int glType = Pixmap.Format.toGlType(this.format);
        GLOnlyTextureData data = new GLOnlyTextureData(this.width, this.height, 0, glFormat, glFormat, glType);
        Cubemap result2 = new Cubemap(data, data, data, data, data, data);
        result2.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        result2.setWrap(Texture.TextureWrap.ClampToEdge, Texture.TextureWrap.ClampToEdge);
        return result2;
    }

    @Override
    protected void disposeColorTexture(Cubemap colorTexture) {
        colorTexture.dispose();
    }

    @Override
    public void bind() {
        this.currentSide = -1;
        super.bind();
    }

    public boolean nextSide() {
        if (this.currentSide > 5) {
            throw new GdxRuntimeException("No remaining sides.");
        }
        if (this.currentSide == 5) {
            return false;
        }
        ++this.currentSide;
        this.bindSide(this.getSide());
        return true;
    }

    protected void bindSide(Cubemap.CubemapSide side) {
        Gdx.gl20.glFramebufferTexture2D(36160, 36064, side.glEnum, ((Cubemap)this.colorTexture).getTextureObjectHandle(), 0);
    }

    public Cubemap.CubemapSide getSide() {
        return this.currentSide < 0 ? null : Cubemap.CubemapSide.values()[this.currentSide];
    }
}

